<?php

namespace App\Providers;

use App\Models\Chat;
use App\Models\ChatRate;
use App\Policies\ChatPolicy;
use App\Policies\ChatRatePolicy;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        Chat::class => ChatPolicy::class,
        ChatRate::class => ChatRatePolicy::class,
    ];

    /**
     * Register any authentication / authorization services.
     */
    public function boot(): void
    {
        $this->registerPolicies();

        // You can also define gates here if needed
        // Gate::define('view-chat', [ChatPolicy::class, 'view']);
    }
}
