<?php

namespace App\Providers;

use App\Contracts\FetchAuthenticatedUserContract;
use App\Contracts\FetchChatsByUserContract;
use App\Contracts\FetchMessagesByChatContract;
use App\Queries\FetchAuthenticatedUser;
use App\Queries\FetchChatsByUser;
use App\Queries\FetchMessagesByChat;
use Illuminate\Support\ServiceProvider;

final class BindingServiceProvider extends ServiceProvider
{
    public array $bindings = [
        FetchAuthenticatedUserContract::class => FetchAuthenticatedUser::class,
        FetchChatsByUserContract::class => FetchChatsByUser::class,
        FetchMessagesByChatContract::class => FetchMessagesByChat::class,
    ];
}
