<?php

namespace App\Queries;

use App\Contracts\FetchAuthenticatedUserContract;
use App\Models\User;
use Illuminate\Contracts\Auth\Factory;
use Spatie\QueryBuilder\QueryBuilder;

final readonly class FetchAuthenticatedUser implements FetchAuthenticatedUserContract
{
    public function __construct(
        private Factory $factory,
    )
    { }

    public function handle(array $includes = [], array $filters = []): User
    {
        return QueryBuilder::for(
            subject: User::class,
        )->allowedIncludes(
            includes: $includes
        )->allowedFilters(
            filters: $filters
        )->findOrFail(
            id: (string)$this->factory->guard('sanctum')->id(),
        );
    }
}
