<?php

namespace App\Queries;

use App\Contracts\FetchChatsByUserContract;
use App\Models\Chat;
use App\Models\Message;
use App\Models\User;
use Illuminate\Database\Eloquent\Builder;
use Spatie\QueryBuilder\QueryBuilder;

final readonly class FetchChatsByUser implements FetchChatsByUserContract
{
    public function handle(User $user, array $includes = [], array $filters = []): Builder
    {
        return QueryBuilder::for(
            subject: Chat::class,
        )->where(
            column: 'user_id',
            operator: '=',
            value: $user->id,
        )->allowedIncludes(
            includes: $includes
        )->allowedFilters(
            filters: $filters
        )->getEloquentBuilder();
    }
}
