<?php

namespace App\Queries;

use App\Contracts\FetchMessagesByChatContract;
use App\Models\Chat;
use App\Models\Message;
use Illuminate\Database\Eloquent\Builder;
use Spatie\QueryBuilder\QueryBuilder;

final class FetchMessagesByChat implements FetchMessagesByChatContract
{
    public function handle(Chat $chat, array $includes = [], array $filters = []): Builder
    {
        return QueryBuilder::for(
            subject: Message::query()
                ->with(['sender', 'media', 'replyTo', 'reactions', 'reactions.actor']) // :id,name,gender
                ->where('chat_id', $chat->id)
        )->allowedIncludes(
            includes: $includes
        )->allowedFilters(
            filters: $filters
        )->getEloquentBuilder();
    }
}
