<?php

namespace Database\Factories;

use App\Models\Admin;
use App\Models\SupportCall;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Carbon;

class SupportCallFactory extends Factory
{
    protected $model = SupportCall::class;

    public function definition(): array
    {
        return [
            'answered_at' => Carbon::now(),
            'status' => $this->faker->word(),
            'type' => $this->faker->word(),
            'room_name' => $this->faker->name(),
            'started_at' => Carbon::now(),
            'ended_at' => Carbon::now(),
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),

            'user_id' => User::factory(),
            'admin_id' => Admin::factory(),
        ];
    }
}
