<?php

use App\Models\Admin;
use App\Models\Chat;
use App\Models\User;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('support_calls', function (Blueprint $table) {
            $table->id();
            $table->string('status');
            $table->string('type');
            $table->string('room_name');
            $table->timestamp('started_at');
            $table->timestamp('answered_at')->nullable();
            $table->timestamp('ended_at')->nullable();
            $table->foreignIdFor(User::class)->constrained('users')->cascadeOnDelete();
            $table->foreignIdFor(Chat::class)->constrained('chats')->cascadeOnDelete();
            $table->foreignIdFor(Admin::class)->nullable()->constrained('admins')->cascadeOnDelete();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('support_calls');
    }
};
