<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('chat_rates', function (Blueprint $table) {
            $table->id();
            $table->morphs('ratefromable');
            $table->morphs('ratetoable');
            $table->foreignId('chat_id')->nullable()->constrained()->onDelete('set null');

            $table->unsignedTinyInteger('rate');
            $table->text('comment')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('chat_rates');
    }
};
