<?php

use App\Models\Message;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('messages', function (Blueprint $table) {
            $table->after('read_at', function (Blueprint $table) {
                $table->foreignIdFor(Message::class, 'reply_to_id')
                    ->nullable()
                    ->index()
                    ->constrained()
                    ->cascadeOnDelete();
                $table->boolean('is_pinned')->default(false);
            });
        });
    }

    public function down(): void
    {
        Schema::table('messages', function (Blueprint $table) {
            $table->dropForeignIdFor(Message::class, 'reply_to_id');
            $table->dropColumn('is_pinned');
        });
    }
};
