<?php

use App\Models\Chat;
use App\Models\Message;
use App\Models\User;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('message_reactions', function (Blueprint $table) {
            $table->id();
            $table->string('emoji');
            $table->foreignIdFor(Message::class)->constrained('messages');
            $table->foreignIdFor(Chat::class)->constrained('chats');
            $table->morphs('actor');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('message_reactions');
    }
};
