import { ref, watch } from 'vue';

export function useCalls(calls) {
    const sortedCalls = ref([]);

    watch(
        () => calls.value,
        (newCalls) => {
            sortedCalls.value = [...newCalls]
                .filter((call) => call.status === 'pending')
                .sort(
                    (a, b) => new Date(b.created_at) - new Date(a.created_at),
                );
        },
        { immediate: true },
    );

    return {
        sortedCalls,
    };
}
