import { ref, watch } from 'vue';

export function useChats(chats) {
    const sortedChats = ref([]);

    watch(
        () => chats.value,
        (newChats) => {
            sortedChats.value = [...newChats];
        },
        { immediate: true },
    );

    const selectedChat = ref(sortedChats.value[0] ?? null);

    const selectChat = (chat) => {
        selectedChat.value = chat;
    };

    return {
        sortedChats,
        selectedChat,
        selectChat,
    };
}
