/**
 * Audio utility functions for chat audio message playback
 */

/**
 * Formats time in seconds to MM:SS format
 * @param {number} timeInSeconds - Time in seconds
 * @returns {string} Formatted time string
 */
export function formatTime(timeInSeconds) {
    const minutes = Math.floor(timeInSeconds / 60);
    const seconds = Math.floor(timeInSeconds % 60);
    return `${minutes}:${seconds.toString().padStart(2, '0')}`;
}

/**
 * Gets a unique key for an audio file
 * @param {Object} audioFile - Audio file object
 * @returns {string|number} Unique identifier for the audio file
 */
export function getAudioKey(audioFile) {
    return audioFile.id ?? audioFile.original_url;
}
