/**
 * Scrolling utility functions for chat message navigation
 */

/**
 * Scrolls to a specific message and highlights it temporarily
 * @param {number} messageId - The ID of the message to scroll to
 */
export function scrollToMessage(messageId) {
    const element = document.getElementById(`message-${messageId}`);
    if (element) {
        element.scrollIntoView({ behavior: 'smooth', block: 'center' });
        element.classList.add('ring-4', 'ring-green-200');
        setTimeout(
            () => element.classList.remove('ring-4', 'ring-green-200'),
            1500,
        );
    }
}
