import Echo from 'laravel-echo';

import Pusher from 'pusher-js';
window.Pusher = Pusher;

const isSecure = (import.meta.env.VITE_REVERB_SCHEME ?? 'http') === 'https';

window.Echo = new Echo({
    broadcaster: 'reverb',
    key: import.meta.env.VITE_REVERB_APP_KEY,
    wsHost: import.meta.env.VITE_REVERB_HOST ?? '127.0.0.1',
    wsPort: isSecure ? null : parseInt(import.meta.env.VITE_REVERB_PORT ?? '6001'),
    wssPort: isSecure ? parseInt(import.meta.env.VITE_REVERB_PORT ?? '443') : null,
    forceTLS: isSecure,
    enabledTransports: ['ws', 'wss'],
});
