<?php

use Illuminate\Support\Facades\Broadcast;

Broadcast::channel('App.Models.User.{id}', function ($user, $id) {
    return (int)$user->id === (int)$id;
});

Broadcast::channel('Support.Chats', function ($user) {
    return $user instanceof \App\Models\Admin && $user->hasRole('super_admin');
});

Broadcast::channel('Support.Chats.{branchId}', function ($user, int $branchId) {
    if (!$user instanceof \App\Models\Admin) {
        return false;
    }

    if ($user->hasRole('super-admin')) {
        return true;
    }

    return $user->branches()->where('branches.id', $branchId)->exists();
});

Broadcast::channel('Support.Chat.Presence', function () {
    return true;
}, ['guards' => ['api', 'admin']]);

Broadcast::channel('Support.Chat.{chat}', function ($user, $chat) {
    if ($user instanceof \App\Models\Admin) {
        return true;
    }

    $chat = \App\Models\Chat::find($chat);

    if ($chat?->user_id === $user?->id) {
        return true;
    }

    return false;
}, ['guards' => ['api']]);
