<?php

use App\Http\Controllers\API\V1\ChatRates\StoreController;
use App\Http\Controllers\CallController;
use App\Http\Controllers\ChatController;
use App\Http\Controllers\ChatRateController;
use App\Http\Controllers\MessageController;
use App\Http\Controllers\MessageReactionController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\UserSearchController;
use App\Http\Controllers\VisitController;
use App\Models\Chat;
use App\Models\ChatRate;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return redirect()->route('chat.index');
});


Route::middleware('auth:admin')->group(function () {

    Route::resource('chat', ChatController::class)->middleware('can:viewAny,' . Chat::class);
    Route::get('chats/new/{user}', [ChatController::class, 'store'])->name('chat.new');
    Route::get('/users/search', UserSearchController::class)->name('users.search');

    Route::resource('calls', CallController::class);
    Route::resource('messages', MessageController::class);
    Route::patch('/messages/{message}/restore', [MessageController::class, 'restore'])
        ->name('messages.restore');
    Route::post('/messages/{message}/pin', [MessageController::class, 'pin'])->name('messages.pin');
    Route::post('/messages/{message}/forward', [MessageController::class, 'forward'])->name('messages.forward');
    Route::post('/messages/{message}/react', MessageReactionController::class)->name('messages.react');

    Route::get('/my_rates', [ChatRateController::class, 'show'])->name('my_rates.show')->middleware('can:viewAny,' . ChatRate::class);
    Route::post('/chat_rate', [ChatRateController::class, 'store'])->name('my_rates.store');


    Route::post('visits', [VisitController::class, 'store'])->name('visits.store');

    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
//    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
//    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    Route::post('/profile/avatar', [ProfileController::class, 'updateAvatar'])->name('profile.avatar.update');
});

require __DIR__ . '/auth.php';
